/* dhparam.c: initial DH parameters for stunnel */
#include "prototypes.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
DH *get_dh2048(void) {
    static unsigned char dhp_2048[] = {
        0xd1, 0x40, 0xf3, 0x58, 0x71, 0xd6, 0x81, 0xa8, 0x65, 0x1e, 0x6e, 0xdf,
        0xc6, 0xbd, 0xb6, 0x46, 0x1c, 0x96, 0x3e, 0xfc, 0x2a, 0x9c, 0x7d, 0xda,
        0x86, 0x8d, 0x82, 0xa3, 0x5f, 0x36, 0x04, 0x65, 0xce, 0xb0, 0x62, 0xac,
        0x62, 0x0a, 0x31, 0x69, 0xd8, 0x2a, 0x66, 0x0f, 0x8b, 0x1d, 0x7c, 0x94,
        0x97, 0x75, 0x9b, 0x61, 0x7c, 0x5c, 0xe0, 0xb8, 0x5a, 0x0b, 0xa0, 0xfe,
        0xab, 0x53, 0xf7, 0x12, 0xfe, 0x0e, 0x8b, 0xfa, 0xea, 0x8e, 0x5c, 0x7a,
        0x34, 0xd4, 0x17, 0x68, 0x9c, 0x81, 0x9d, 0xa3, 0x96, 0xd3, 0x69, 0x96,
        0xac, 0x36, 0xd7, 0xc4, 0x4b, 0x34, 0xd1, 0x8c, 0x9e, 0x69, 0xf2, 0x36,
        0x9d, 0x22, 0xe3, 0xf8, 0x81, 0xab, 0x60, 0x53, 0x08, 0xb8, 0xee, 0x57,
        0x6f, 0x9d, 0xce, 0x4d, 0x49, 0x60, 0xf8, 0x82, 0x54, 0x99, 0xaa, 0x0a,
        0xb7, 0xcd, 0xf1, 0x9a, 0xe4, 0xc4, 0x2b, 0x45, 0xdd, 0xb3, 0x57, 0xb3,
        0x0d, 0xf7, 0xfa, 0xb7, 0x9d, 0x32, 0xcc, 0xfd, 0xec, 0xed, 0x01, 0x9b,
        0x5b, 0x47, 0x1c, 0xfb, 0x0e, 0xf6, 0xf5, 0x6e, 0xa7, 0x10, 0x79, 0xd1,
        0x0a, 0xd0, 0xe9, 0x66, 0x67, 0x8a, 0x92, 0x66, 0xba, 0xa4, 0x21, 0xf0,
        0xde, 0x4d, 0xb4, 0x55, 0x98, 0x46, 0xaa, 0x1f, 0xd3, 0x01, 0x90, 0x07,
        0xf0, 0x5e, 0x90, 0x14, 0x28, 0xbb, 0x5f, 0xc3, 0x44, 0x6b, 0xc2, 0xdd,
        0xc5, 0xb3, 0xbe, 0x16, 0x40, 0x03, 0xe2, 0x66, 0x6c, 0x3b, 0x49, 0xa3,
        0xd4, 0xd6, 0x0c, 0x6a, 0x53, 0x8f, 0x7e, 0xa5, 0x9c, 0xfe, 0xb3, 0x87,
        0xcc, 0x27, 0x1b, 0x27, 0x19, 0x00, 0xc3, 0x3d, 0xb9, 0x3d, 0xba, 0x7e,
        0x10, 0x6b, 0xa4, 0xb1, 0x18, 0xc0, 0xa1, 0x60, 0xd1, 0xf3, 0x22, 0x70,
        0xb7, 0xb0, 0xfd, 0x39, 0x68, 0x18, 0xb8, 0x29, 0x05, 0x98, 0x4e, 0xdf,
        0x64, 0x13, 0x54, 0x47
    };
    static unsigned char dhg_2048[] = {
        0x02
    };
    DH *dh = DH_new();
    BIGNUM *p, *g;

    if (dh == NULL)
        return NULL;
    p = BN_bin2bn(dhp_2048, sizeof(dhp_2048), NULL);
    g = BN_bin2bn(dhg_2048, sizeof(dhg_2048), NULL);
    if (p == NULL || g == NULL
            || !DH_set0_pqg(dh, p, NULL, g)) {
        DH_free(dh);
        BN_free(p);
        BN_free(g);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
/* built for stunnel 5.77 */
